#include <genesis.h>
#include "menu.h"

static u16 selection = 0;

int scroll1_x = 40;
int scroll2_x = 40;


int scrollDelay = 0;
const int scrollSpeed = 10; // lower number = faster, higher = slower

// Smooth input — detect only when button *becomes pressed*
static void handleInput(u16 joy, u16 changed, u16 state)
{
    if (joy != JOY_1) return;

    if ((changed & state & BUTTON_UP))
    {
        if (selection > 0) selection--;
    }

    if ((changed & state & BUTTON_DOWN))
    {
        if (selection < 3) selection++;
    }
}

int menu_show()
{
    VDP_resetScreen();
    VDP_setTextPlane(BG_A);

    VDP_drawText("MEGACOLLECTION", 12, 4);
    VDP_drawText("------------------", 10, 5);

    const char* entries[4] = {
        "1. MEGAPONG",
        "2. MEGARUNNER",
        "3. MEGALAGA",
        "4. MEGATILER"
    };

    // --- scrolling text setup ---
    const char* scroll1 = " PRESS UP OR DOWN TO CHOOSE GAME ";
    const char* scroll2 = " PRESS START TO PLAY ";
    

    int scroll1_x = 40;
    int scroll2_x = 40;
    

    selection = 0;
    JOY_setEventHandler(handleInput);

    while(1)
    {
        // Draw menu items
        for(int i = 0; i < 4; i++)
        {
            if (i == selection)
                VDP_drawText("* ", 10, 8 + i);
            else
                VDP_drawText("  ", 10, 8 + i);

            VDP_drawText(entries[i], 12, 8 + i);
        }

        // DRAW SCROLLING TEXT
        VDP_clearTextArea(0, 20, 40, 2);

        VDP_drawText(scroll1, scroll1_x, 20);
        VDP_drawText(scroll2, scroll2_x, 21);
        

        // update scroll positions
        scrollDelay++;
        if (scrollDelay >= scrollSpeed)
        {
            scrollDelay = 0;

            scroll1_x--;
            scroll2_x--;
            
        }

        // wrap around
        if (scroll1_x < -(int)strlen(scroll1)) scroll1_x = 40;
        if (scroll2_x < -(int)strlen(scroll2)) scroll2_x = 40;
        

        SYS_doVBlankProcess();

        // START pressed? → return 1–4
        if (JOY_readJoypad(JOY_1) & BUTTON_START)
            return selection + 1;
    }
}
